/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.custom_bogeys.monobogey.IPotentiallyUpsideDownBogeyBlock;
import com.railwayteam.railways.util.BlockStateUtils;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StationTileEntity.class}, remap=false)
public abstract class MixinStationTileEntity
extends SmartTileEntity {
    @Shadow
    int[] bogeyLocations;
    @Shadow
    IBogeyBlock[] bogeyTypes;
    @Shadow
    Direction assemblyDirection;
    boolean[] upsideDownBogeys;
    private boolean bogeyIndexAdd = false;
    private BlockPos overridenBogeyPosOffset = null;
    private int storedBogeyIdx = 0;

    private MixinStationTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"refreshAssemblyInfo"}, at={@At(value="HEAD")})
    private void resetBogeyIndexAdditionsHead(CallbackInfo ci) {
        this.bogeyIndexAdd = false;
    }

    @Inject(method={"refreshAssemblyInfo"}, at={@At(value="RETURN")})
    private void resetBogeyIndexAdditionsReturn(CallbackInfo ci) {
        this.bogeyIndexAdd = false;
    }

    @ModifyVariable(method={"refreshAssemblyInfo"}, at=@At(value="LOAD"), name={"bogeyIndex"})
    private int getRealBogeyIndex(int value) {
        int newValue = value + (this.bogeyIndexAdd ? 1 : 0);
        this.bogeyIndexAdd = false;
        return newValue;
    }

    @ModifyVariable(method={"refreshAssemblyInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;move(Lnet/minecraft/core/Direction;)Lnet/minecraft/core/BlockPos$MutableBlockPos;", ordinal=1, shift=At.Shift.AFTER, remap=true), name={"bogeyIndex"})
    private int setRealBogeyIndex(int value) {
        int newValue = value + (this.bogeyIndexAdd ? 1 : 0);
        this.bogeyIndexAdd = false;
        return newValue;
    }

    @Inject(method={"refreshAssemblyInfo"}, at={@At(value="INVOKE", target="Ljava/util/Arrays;fill([II)V")})
    private void resetUpsideDownBogeyList(CallbackInfo ci) {
        if (this.upsideDownBogeys == null) {
            this.upsideDownBogeys = new boolean[((Integer)AllConfigs.SERVER.trains.maxBogeyCount.get()).intValue()];
        }
        Arrays.fill(this.upsideDownBogeys, false);
    }

    @Redirect(method={"refreshAssemblyInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;", remap=true))
    private Block preventUpsideDownBogeyOnTop(BlockState instance) {
        IPotentiallyUpsideDownBogeyBlock pubd;
        Block block = instance.m_60734_();
        return block instanceof IPotentiallyUpsideDownBogeyBlock && (pubd = (IPotentiallyUpsideDownBogeyBlock)block).isUpsideDown() ? Blocks.f_50016_ : block;
    }

    @Inject(method={"refreshAssemblyInfo"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;move(Lnet/minecraft/core/Direction;)Lnet/minecraft/core/BlockPos$MutableBlockPos;", ordinal=1, remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void includeUpsideDownBogeys(CallbackInfo ci, int prevLength, BlockPos targetPosition, BlockState trackState, ITrackBlock track, BlockPos.MutableBlockPos currentPos, BlockPos bogeyOffset, int MAX_LENGTH, int MAX_BOGEY_COUNT, int bogeyIndex, int maxBogeyCount, int i, BlockState potentialBogeyState) {
        block5: {
            IPotentiallyUpsideDownBogeyBlock potentiallyUpsideDownBogey;
            IBogeyBlock bogey;
            BlockPos upsideDownBogeyOffset;
            Block block;
            block4: {
                IPotentiallyUpsideDownBogeyBlock pubd;
                Block block2 = potentialBogeyState.m_60734_();
                if (!(block2 instanceof IBogeyBlock)) break block4;
                IBogeyBlock bogey2 = (IBogeyBlock)block2;
                block2 = potentialBogeyState.m_60734_();
                if ((!(block2 instanceof IPotentiallyUpsideDownBogeyBlock) || !(pubd = (IPotentiallyUpsideDownBogeyBlock)block2).isUpsideDown()) && bogeyIndex < this.bogeyLocations.length) break block5;
            }
            if ((block = (potentialBogeyState = this.f_58857_.m_8055_((upsideDownBogeyOffset = new BlockPos(bogeyOffset.m_123341_(), bogeyOffset.m_123342_() * -1, bogeyOffset.m_123343_())).m_141952_((Vec3i)currentPos))).m_60734_()) instanceof IBogeyBlock && (bogey = (IBogeyBlock)block) instanceof IPotentiallyUpsideDownBogeyBlock && (potentiallyUpsideDownBogey = (IPotentiallyUpsideDownBogeyBlock)bogey).isUpsideDown() && bogeyIndex < this.bogeyLocations.length) {
                this.bogeyTypes[bogeyIndex] = bogey;
                this.bogeyLocations[bogeyIndex] = i;
                this.upsideDownBogeys[bogeyIndex] = true;
                this.bogeyIndexAdd = true;
            }
        }
    }

    @Inject(method={"assemble"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/CarriageContraption;assemble(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void storeBogeyData(UUID playerUUID, CallbackInfo ci, BlockPos trackPosition, BlockState trackState, ITrackBlock track, BlockPos bogeyOffset, TrackNodeLocation location, Vec3 centre, Collection ends, Vec3 targetOffset, List pointOffsets, int iPrevious, List points, Vec3 directionVec, TrackGraph graph, TrackNode secondNode, List<?> contraptions, List<?> carriages, List<?> spacing, boolean atLeastOneForwardControls, int bogeyIndex) {
        if (this.upsideDownBogeys[bogeyIndex]) {
            this.overridenBogeyPosOffset = trackPosition.m_141952_((Vec3i)new BlockPos(bogeyOffset.m_123341_(), bogeyOffset.m_123342_() * -1, bogeyOffset.m_123343_()));
        }
        this.storedBogeyIdx = bogeyIndex;
    }

    @Redirect(method={"assemble"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/CarriageContraption;assemble(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", remap=true))
    private boolean assembleCorrectBogey(CarriageContraption instance, Level level, BlockPos bogeyPos) throws AssemblyException {
        boolean success = instance.assemble(level, this.overridenBogeyPosOffset != null ? this.overridenBogeyPosOffset.m_5484_(this.assemblyDirection, this.bogeyLocations[this.storedBogeyIdx] + 1) : bogeyPos);
        this.overridenBogeyPosOffset = null;
        return success;
    }

    @Redirect(method={"assemble"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/CarriageContraption;getSecondBogeyPos()Lnet/minecraft/core/BlockPos;", remap=true))
    private BlockPos storeBogeyDataForOrderCheck(CarriageContraption instance) {
        BlockPos pos = instance.getSecondBogeyPos();
        return pos == null ? null : pos.m_6630_(this.storedBogeyIdx + 1 < this.upsideDownBogeys.length && this.upsideDownBogeys[this.storedBogeyIdx + 1] ? 2 : 0);
    }

    @Inject(method={"trackClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;offset(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/core/BlockPos;", remap=true, ordinal=1)}, cancellable=true)
    private void placeUpsideDownBogey(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState bogeyAnchor;
        Block block;
        if (player.m_5686_(1.0f) < 0.0f && (block = (bogeyAnchor = track.getBogeyAnchor((BlockGetter)this.f_58857_, pos, state)).m_60734_()) instanceof IPotentiallyUpsideDownBogeyBlock) {
            IPotentiallyUpsideDownBogeyBlock pudb = (IPotentiallyUpsideDownBogeyBlock)block;
            BlockPos targetPos = pos.m_141952_((Vec3i)new BlockPos(track.getUpNormal((BlockGetter)this.f_58857_, pos, state).m_82542_(-1.0, -1.0, -1.0)));
            if (this.f_58857_.m_8055_(targetPos).m_60800_((BlockGetter)this.f_58857_, targetPos) == -1.0f) {
                cir.setReturnValue((Object)false);
                return;
            }
            this.f_58857_.m_46961_(targetPos, true);
            bogeyAnchor = ProperWaterloggedBlock.withWater((LevelAccessor)this.f_58857_, (BlockState)pudb.getVersion(bogeyAnchor, true), (BlockPos)pos);
            this.f_58857_.m_7731_(targetPos, bogeyAnchor, 3);
            player.m_5661_((Component)Lang.translateDirect((String)"train_assembly.bogey_created", (Object[])new Object[0]), true);
            SoundType soundtype = BlockStateUtils.getSoundType(bogeyAnchor, (LevelReader)this.f_58857_, pos, (Entity)player);
            this.f_58857_.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (!player.m_7500_()) {
                ItemStack itemInHand = player.m_21120_(hand);
                itemInHand.m_41774_(1);
                if (itemInHand.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
            cir.setReturnValue((Object)true);
            return;
        }
    }
}

